/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.radar;

import java.util.Collections;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import tech.vvp.vvp.network.VVPNetwork;
import tech.vvp.vvp.network.message.S2CRadarStatePacket;
import tech.vvp.vvp.network.message.S2CRadarSyncPacket;
import tech.vvp.vvp.radar.IRadarVehicle;

@Mod.EventBusSubscriber(modid="vvp")
public class RadarSystem {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.m_129785_()) {
            for (ServerPlayer player : level.m_6907_()) {
                Entity vehicle;
                if (player.f_19797_ % 20 != 0 || !((vehicle = player.m_20202_()) instanceof IRadarVehicle)) continue;
                IRadarVehicle rv = (IRadarVehicle)vehicle;
                if (vehicle.m_146895_() != player || !rv.isRadarEnabled()) continue;
                if (!rv.consumeRadarEnergy()) {
                    rv.setRadarEnabled(false);
                    VVPNetwork.VVP_HANDLER.sendTo((Object)new S2CRadarStatePacket(false), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    VVPNetwork.VVP_HANDLER.sendTo((Object)new S2CRadarSyncPacket(Collections.emptyList()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    continue;
                }
                rv.scanAndSendRadarTo(player);
            }
        }
    }
}

